/*!---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var error_reporter_base_1 = require("./error-reporter-base");
var advanced_1 = require("./advanced");
var try_all_1 = require("./try-all");
(function (State) {
    State[State["ready"] = 0] = "ready";
    State[State["reporting"] = 1] = "reporting";
    State[State["finishing"] = 2] = "finishing";
})(exports.State || (exports.State = {}));
var State = exports.State;
var ERROR_REPORTING_ASYNC_FAILURE = "ErrorReportAsyncFailure";
var USER_CALLBACK_UNCAUGHT_EXCEPTION = "userCallbackUncaught";
var ErrorHandlerNode = (function (_super) {
    __extends(ErrorHandlerNode, _super);
    function ErrorHandlerNode(options) {
        _super.call(this, { appRoot: options.appRoot, packageInfo: options.packageInfo, exeName: options.exeName });
        this.errorType = "NodeFatal";
        this.finalCallback = options.finalCallback;
        this.currentState = State.ready;
        advanced_1.setStackTraceLimit(Infinity);
        process.on("uncaughtException", this.handleUncaughtMain.bind(this));
    }
    ErrorHandlerNode.prototype.handleUncaughtMain = function (err) {
        var _this = this;
        if (this.currentState === State.ready) {
            this.currentState = State.reporting;
        }
        else if (this.currentState === State.reporting) {
            try {
                this.emitAsyncFailure(err);
            }
            catch (e) {
            }
            return;
        }
        else if (this.currentState === State.finishing) {
            this.finalExit();
        }
        var e = advanced_1.coerceToError(err);
        this.reportError(e, this.errorType).then(function () { _this.finishHandling(e); });
    };
    ErrorHandlerNode.prototype.finishHandling = function (err) {
        this.currentState = State.finishing;
        try {
            if (this.finalCallback && this.finalCallback(err)) {
                this.currentState = State.ready;
                return;
            }
        }
        catch (e) {
            try {
                this.emitUserCallbackUncaughtException(e);
            }
            catch (e1) {
            }
        }
        try {
            this.emitAboutToExit().then(this.finalExit, this.finalExit);
            setTimeout(this.finalExit, 500);
        }
        catch (e2) {
            this.finalExit();
        }
    };
    ErrorHandlerNode.prototype.finalExit = function () {
        if (process.platform === "win32") {
            process.abort();
        }
        process.exit(1);
    };
    ErrorHandlerNode.prototype.onAboutToExit = function (callback) {
        if (this.aboutToExitPromises === undefined) {
            this.aboutToExitPromises = [];
        }
        this.aboutToExitPromises.push(callback);
    };
    ErrorHandlerNode.prototype.emitAboutToExit = function () {
        if (this.aboutToExitPromises) {
            var promises_1 = [];
            this.aboutToExitPromises.forEach(function (element) {
                try {
                    promises_1.push(element());
                }
                catch (e) {
                }
            });
            return try_all_1.tryAll(promises_1);
        }
        return Promise.resolve();
    };
    ErrorHandlerNode.prototype.onAsyncFailure = function (callback) {
        this.emitter.on(ERROR_REPORTING_ASYNC_FAILURE, callback);
    };
    ErrorHandlerNode.prototype.emitAsyncFailure = function (asyncError) {
        return this.emitter.emit(ERROR_REPORTING_ASYNC_FAILURE, asyncError);
    };
    ErrorHandlerNode.prototype.onUserCallbackUncaughtException = function (callback) {
        this.emitter.on(USER_CALLBACK_UNCAUGHT_EXCEPTION, callback);
    };
    ErrorHandlerNode.prototype.emitUserCallbackUncaughtException = function (uncaughtException) {
        this.emitter.emit(USER_CALLBACK_UNCAUGHT_EXCEPTION, uncaughtException);
    };
    return ErrorHandlerNode;
}(error_reporter_base_1.ErrorReporter));
exports.ErrorHandlerNode = ErrorHandlerNode;

// SIG // Begin signature block
// SIG // MIIiAAYJKoZIhvcNAQcCoIIh8TCCIe0CAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // X2JySS0hkppHdOuC6TZF4iU7Ea8dqA0bmxg40eCo6VKg
// SIG // gguEMIIFDDCCA/SgAwIBAgITMwAAAU/nxmLJRvSpfwAA
// SIG // AAABTzANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDEwMB4XDTE2MTExNzIxNTkxNFoX
// SIG // DTE4MDIxNzIxNTkxNFowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBALSJkIp2DKzFPaG8gejXUAi7
// SIG // WmmnrsfMuFu9OA8hUUYII9G9Iplztyjv9werK/lI96UU
// SIG // BalNJBttYZacg50zwCx5mfBd8+zVRN+lzVn6dq0GP8ZK
// SIG // A+bqLZQQwmZv/WLQUIrRIpEjl2U0ocSaAl6S4rh8KHjC
// SIG // XuNG98rvOFeIrFYGWMqYG8eo1142rppFMOO2tz0Ywqcn
// SIG // sHlNU9gy5najUCr2P7q7QR4khk2Ym3qe9izivJBgZfuW
// SIG // afrgE2jiiSoudRidwm24IfSZXip/MaCnDczvTxFu/klC
// SIG // TmHeN8srnkDvzqtecAhzpXJ7t0bOWzJTXYo5UW+w16h4
// SIG // 3aMob17uQh8CAwEAAaOCAXswggF3MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjc9BgEGCCsGAQUFBwMDMB0GA1UdDgQWBBSS
// SIG // DqERcbYvVQ3DD/TJXHQuWgxqvzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwODY1
// SIG // K2I0YjEyODc4LWUyOTMtNDNlOS1iMjFlLTdkMzA3MTlk
// SIG // NDUyZjAfBgNVHSMEGDAWgBTm/F97uyIAWORyTrX0IXQj
// SIG // MubvrDBWBgNVHR8ETzBNMEugSaBHhkVodHRwOi8vY3Js
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9N
// SIG // aWNDb2RTaWdQQ0FfMjAxMC0wNy0wNi5jcmwwWgYIKwYB
// SIG // BQUHAQEETjBMMEoGCCsGAQUFBzAChj5odHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY0NvZFNp
// SIG // Z1BDQV8yMDEwLTA3LTA2LmNydDAMBgNVHRMBAf8EAjAA
// SIG // MA0GCSqGSIb3DQEBCwUAA4IBAQARwLlqQzX+hbE4gA24
// SIG // dHUsjXFJuDxB7S294gY2kHYrieW2gemG4xiMlpMyQqen
// SIG // 9rc0JTnQxnpD6tt3cMzU6ULrqMVVAnV4ntgQvgcbypRj
// SIG // +zwPce7UVWfXKfZqvwe85Y+C6vih4nMzPxSSXqG6ZVc3
// SIG // RYWAXNYsxos8aoejBxHL7NlxOCA1JD1UvcxVifR3EJvl
// SIG // maoPrsY8jp/aAE/PfeGzwCD3UjH3IkjVYY1/JgIZfYPM
// SIG // YZMq3bjc4gizp9/hBHdgyPSsNcsx5Wx1UcU3exNqTpVr
// SIG // j0CeyE0+rr1ZxSDWwnitt2RbO9DAFXA0FOXFnqYcx/T/
// SIG // 9stIweKN827OqrSgMIIGcDCCBFigAwIBAgIKYQxSTAAA
// SIG // AAAAAzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMC
// SIG // VVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcT
// SIG // B1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jw
// SIG // b3JhdGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3Qg
// SIG // Q2VydGlmaWNhdGUgQXV0aG9yaXR5IDIwMTAwHhcNMTAw
// SIG // NzA2MjA0MDE3WhcNMjUwNzA2MjA1MDE3WjB+MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQg
// SIG // Q29kZSBTaWduaW5nIFBDQSAyMDEwMIIBIjANBgkqhkiG
// SIG // 9w0BAQEFAAOCAQ8AMIIBCgKCAQEA6Q5kUHlntcTj/QkA
// SIG // TJ6UrPdWaOpE2M/FWE+ppXZ8bUW60zmStKQe+fllguQX
// SIG // 0o/9RJwI6GWTzixVhL99COMuK6hBKxi3oktuSUxrFQfe
// SIG // 0dLCiR5xlM21f0u0rwjYzIjWaxeUOpPOJj/s5v40mFfV
// SIG // HV1J9rIqLtWFu1k/+JC0K4N0yiuzO0bj8EZJwRdmVMkc
// SIG // vR3EVWJXcvhnuSUgNN5dpqWVXqsogM3Vsp7lA7Vj07IU
// SIG // yMHIiiYKWX8H7P8O7YASNUwSpr5SW/Wm2uCLC0h31oVH
// SIG // 1RC5xuiq7otqLQVcYMa0KlucIxxfReMaFB5vN8sZM4Bq
// SIG // iU2jamZjeJPVMM+VHwIDAQABo4IB4zCCAd8wEAYJKwYB
// SIG // BAGCNxUBBAMCAQAwHQYDVR0OBBYEFOb8X3u7IgBY5HJO
// SIG // tfQhdCMy5u+sMBkGCSsGAQQBgjcUAgQMHgoAUwB1AGIA
// SIG // QwBBMAsGA1UdDwQEAwIBhjAPBgNVHRMBAf8EBTADAQH/
// SIG // MB8GA1UdIwQYMBaAFNX2VsuP6KJcYmjRPZSQW9fOmhjE
// SIG // MFYGA1UdHwRPME0wS6BJoEeGRWh0dHA6Ly9jcmwubWlj
// SIG // cm9zb2Z0LmNvbS9wa2kvY3JsL3Byb2R1Y3RzL01pY1Jv
// SIG // b0NlckF1dF8yMDEwLTA2LTIzLmNybDBaBggrBgEFBQcB
// SIG // AQROMEwwSgYIKwYBBQUHMAKGPmh0dHA6Ly93d3cubWlj
// SIG // cm9zb2Z0LmNvbS9wa2kvY2VydHMvTWljUm9vQ2VyQXV0
// SIG // XzIwMTAtMDYtMjMuY3J0MIGdBgNVHSAEgZUwgZIwgY8G
// SIG // CSsGAQQBgjcuAzCBgTA9BggrBgEFBQcCARYxaHR0cDov
// SIG // L3d3dy5taWNyb3NvZnQuY29tL1BLSS9kb2NzL0NQUy9k
// SIG // ZWZhdWx0Lmh0bTBABggrBgEFBQcCAjA0HjIgHQBMAGUA
// SIG // ZwBhAGwAXwBQAG8AbABpAGMAeQBfAFMAdABhAHQAZQBt
// SIG // AGUAbgB0AC4gHTANBgkqhkiG9w0BAQsFAAOCAgEAGnTv
// SIG // V08pe8QWhXi4UNMi/AmdrIKX+DT/KiyXlRLl5L/Pv5PI
// SIG // 4zSp24G43B4AvtI1b6/lf3mVd+UC1PHr2M1OHhthosJa
// SIG // IxrwjKhiUUVnCOM/PB6T+DCFF8g5QKbXDrMhKeWloWmM
// SIG // IpPMdJjnoUdD8lOswA8waX/+0iUgbW9h098H1dlyACxp
// SIG // hnY9UdumOUjJN2FtB91TGcun1mHCv+KDqw/ga5uV1n0o
// SIG // UbCJSlGkmmzItx9KGg5pqdfcwX7RSXCqtq27ckdjF/qm
// SIG // 1qKmhuyoEESbY7ayaYkGx0aGehg/6MUdIdV7+QIjLcVB
// SIG // y78dTMgW77Gcf/wiS0mKbhXjpn92W9FTeZGFndXS2z1z
// SIG // NfM8rlSyUkdqwKoTldKOEdqZZ14yjPs3hdHcdYWch8Za
// SIG // V4XCv90Nj4ybLeu07s8n07VeafqkFgQBpyRnc89NT7be
// SIG // BVaXevfpUk30dwVPhcbYC/GO7UIJ0Q124yNWeCImNr7K
// SIG // sYxuqh3khdpHM2KPpMmRM19xHkCvmGXJIuhCISWKHC1g
// SIG // 2TeJQYkqFg/XYTyUaGBS79ZHmaCAQO4VgXc+nOBTGBpQ
// SIG // HTiVmx5mMxMnORd4hzbOTsNfsvU9R1O24OXbC2E9KteS
// SIG // LM43Wj5AQjGkHxAIwlacvyRdUQKdannSF9PawZSOB3sl
// SIG // cUSrBmrm1MbfI5qWdcUxghXUMIIV0AIBATCBlTB+MQsw
// SIG // CQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQ
// SIG // MA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9z
// SIG // b2Z0IENvcnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3Nv
// SIG // ZnQgQ29kZSBTaWduaW5nIFBDQSAyMDEwAhMzAAABT+fG
// SIG // YslG9Kl/AAAAAAFPMA0GCWCGSAFlAwQCAQUAoIHCMBkG
// SIG // CSqGSIb3DQEJAzEMBgorBgEEAYI3AgEEMBwGCisGAQQB
// SIG // gjcCAQsxDjAMBgorBgEEAYI3AgEVMC8GCSqGSIb3DQEJ
// SIG // BDEiBCDzxyXdqM2m1+bb1p+ClzdkeqvF4hCwlb9Pc3fA
// SIG // ajB63zBWBgorBgEEAYI3AgEMMUgwRqAsgCoAZQByAHIA
// SIG // bwByAC0AaABhAG4AZABsAGUAcgAtAG4AbwBkAGUALgBq
// SIG // AHOhFoAUaHR0cDovL21pY3Jvc29mdC5jb20wDQYJKoZI
// SIG // hvcNAQEBBQAEggEAG5aVPlzM96UjCnXgBkhZHqs0tIDu
// SIG // obONcr74c1YtwJ5e57qyRS6SsU8EknldPgTjYjJGgTPi
// SIG // mYx86AKtVZ3KjE9m9RgdJf+CF6IQCmcbeBt8sphGwOm8
// SIG // JZ3S2PC5tGt0UetRd4NW/ccSyqD/eN1XbiMC2b04fgQP
// SIG // zffjm8AGI6uplsCY1NQSsHS3FTb0KSl+b2AOhSGIDrSi
// SIG // ZqsLbHNoUKPDE2JtDCEjQ7wnosEBhtnCc3cX8rHe3tug
// SIG // v3ii0s7EOqQ57R8MtRZ+P4tzIMPRxbXcPGzWfclZ9GQq
// SIG // XkL1kh5pftcQHhB/buaHXKsKJCoyXguN6Uzt28uzj9bk
// SIG // BE4FvqGCE0owghNGBgorBgEEAYI3AwMBMYITNjCCEzIG
// SIG // CSqGSIb3DQEHAqCCEyMwghMfAgEDMQ8wDQYJYIZIAWUD
// SIG // BAIBBQAwggE9BgsqhkiG9w0BCRABBKCCASwEggEoMIIB
// SIG // JAIBAQYKKwYBBAGEWQoDATAxMA0GCWCGSAFlAwQCAQUA
// SIG // BCBtmiiicPDlhXP2j2mOyqJeHScmVsn7BoYY4Ya/QXCe
// SIG // mAIGWD8xSjqyGBMyMDE2MTIyODAwNTgwNi42NzRaMAcC
// SIG // AQGAAgH0oIG5pIG2MIGzMQswCQYDVQQGEwJVUzETMBEG
// SIG // A1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9u
// SIG // ZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9u
// SIG // MQ0wCwYDVQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lwaGVy
// SIG // IERTRSBFU046RjUyOC0zNzc3LThBNzYxJTAjBgNVBAMT
// SIG // HE1pY3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZpY2Wggg7N
// SIG // MIIGcTCCBFmgAwIBAgIKYQmBKgAAAAAAAjANBgkqhkiG
// SIG // 9w0BAQsFADCBiDELMAkGA1UEBhMCVVMxEzARBgNVBAgT
// SIG // Cldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAc
// SIG // BgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEyMDAG
// SIG // A1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2VydGlmaWNhdGUg
// SIG // QXV0aG9yaXR5IDIwMTAwHhcNMTAwNzAxMjEzNjU1WhcN
// SIG // MjUwNzAxMjE0NjU1WjB8MQswCQYDVQQGEwJVUzETMBEG
// SIG // A1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9u
// SIG // ZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9u
// SIG // MSYwJAYDVQQDEx1NaWNyb3NvZnQgVGltZS1TdGFtcCBQ
// SIG // Q0EgMjAxMDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCC
// SIG // AQoCggEBAKkdDbx3EYo6IOz8E5f1+n9plGt0VBDVpQoA
// SIG // goX77XxoSyxfxcPlYcJ2tz5mK1vwFVMnBDEfQRsalR3O
// SIG // CROOfGEwWbEwRA/xYIiEVEMM1024OAizQt2TrNZzMFcm
// SIG // gqNFDdDq9UeBzb8kYDJYYEbyWEeGMoQedGFnkV+BVLHP
// SIG // k0ySwcSmXdFhE24oxhr5hoC732H8RsEnHSRnEnIaIYqv
// SIG // S2SJUGKxXf13Hz3wV3WsvYpCTUBR0Q+cBj5nf/VmwAOW
// SIG // RH7v0Ev9buWayrGo8noqCjHw2k4GkbaICDXoeByw6ZnN
// SIG // POcvRLqn9NxkvaQBwSAJk3jN/LzAyURdXhacAQVPIk0C
// SIG // AwEAAaOCAeYwggHiMBAGCSsGAQQBgjcVAQQDAgEAMB0G
// SIG // A1UdDgQWBBTVYzpcijGQ80N7fEYbxTNoWoVtVTAZBgkr
// SIG // BgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8EBAMC
// SIG // AYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAWgBTV
// SIG // 9lbLj+iiXGJo0T2UkFvXzpoYxDBWBgNVHR8ETzBNMEug
// SIG // SaBHhkVodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20vcGtp
// SIG // L2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXRfMjAxMC0w
// SIG // Ni0yMy5jcmwwWgYIKwYBBQUHAQEETjBMMEoGCCsGAQUF
// SIG // BzAChj5odHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtp
// SIG // L2NlcnRzL01pY1Jvb0NlckF1dF8yMDEwLTA2LTIzLmNy
// SIG // dDCBoAYDVR0gAQH/BIGVMIGSMIGPBgkrBgEEAYI3LgMw
// SIG // gYEwPQYIKwYBBQUHAgEWMWh0dHA6Ly93d3cubWljcm9z
// SIG // b2Z0LmNvbS9QS0kvZG9jcy9DUFMvZGVmYXVsdC5odG0w
// SIG // QAYIKwYBBQUHAgIwNB4yIB0ATABlAGcAYQBsAF8AUABv
// SIG // AGwAaQBjAHkAXwBTAHQAYQB0AGUAbQBlAG4AdAAuIB0w
// SIG // DQYJKoZIhvcNAQELBQADggIBAAfmiFEN4sbgmD+BcQM9
// SIG // naOhIW+z66bM9TG+zwXiqf76V20ZMLPCxWbJat/15/B4
// SIG // vceoniXj+bzta1RXCCtRgkQS+7lTjMz0YBKKdsxAQEGb
// SIG // 3FwX/1z5Xhc1mCRWS3TvQhDIr79/xn/yN31aPxzymXlK
// SIG // kVIArzgPF/UveYFl2am1a+THzvbKegBvSzBEJCI8z+0D
// SIG // pZaPWSm8tv0E4XCfMkon/VWvL/625Y4zu2JfmttXQOnx
// SIG // zplmkIz/amJ/3cVKC5Em4jnsGUpxY517IW3DnKOiPPp/
// SIG // fZZqkHimbdLhnPkd/DjYlPTGpQqWhqS9nhquBEKDuLWA
// SIG // myI4ILUl5WTs9/S/fmNZJQ96LjlXdqJxqgaKD4kWumGn
// SIG // Ecua2A5HmoDF0M2n0O99g/DhO3EJ3110mCIIYdqwUB5v
// SIG // vfHhAN/nMQekkzr3ZUd46PioSKv33nJ+YWtvd6mBy6cJ
// SIG // rDm77MbL2IK0cs0d9LiFAR6A+xuJKlQ5slvayA1VmXqH
// SIG // czsI5pgt6o3gMy4SKfXAL1QnIffIrE7aKLixqduWsqdC
// SIG // osnPGUFN4Ib5KpqjEWYw07t0MkvfY3v1mYovG8chr1m1
// SIG // rtxEPJdQcdeh0sVV42neV8HR3jDA/czmTfsNv11P6Z0e
// SIG // GTgvvM9YBS7vDaBQNdrvCScc1bN+NR4Iuto229Nfj950
// SIG // iEkSMIIE2jCCA8KgAwIBAgITMwAAALCG6ZIgCl3q+AAA
// SIG // AAAAsDANBgkqhkiG9w0BAQsFADB8MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSYwJAYDVQQDEx1NaWNyb3NvZnQgVGltZS1T
// SIG // dGFtcCBQQ0EgMjAxMDAeFw0xNjA5MDcxNzU2NTZaFw0x
// SIG // ODA5MDcxNzU2NTZaMIGzMQswCQYDVQQGEwJVUzETMBEG
// SIG // A1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9u
// SIG // ZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9u
// SIG // MQ0wCwYDVQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lwaGVy
// SIG // IERTRSBFU046RjUyOC0zNzc3LThBNzYxJTAjBgNVBAMT
// SIG // HE1pY3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZpY2UwggEi
// SIG // MA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDw5fCN
// SIG // lFmpmtdsCQd3FCFZXbc9eLg1rfUwMf/O4f/W6RrJg5gj
// SIG // +5AQwZLsOrxQbJC9XPFrrUyi9WGlh+EprKM8Et9/xACC
// SIG // zr20Cl/LuduatxktWu0HAK1U/TOs9vgSJEokZ1fauEuh
// SIG // rA+A+Tm9IA21p8QsS/GhVubyLye5JsEzJdkrDDByUIRr
// SIG // kmqVjPL6CE24LiTVQ9Pc6/N0aoizybRg3MllrV8J5RFq
// SIG // FDTB5FcGEkbmoL2EWiRCQ/a89CxVmVqNs4imqhKUIr6G
// SIG // tUqJjKpHsKDFHxuPnPBibVSdMtOpxJtT6blyO78Xnq9Y
// SIG // XJ3GK1Ahu9iWzDbvjaZz2a27Q3AVAgMBAAGjggEbMIIB
// SIG // FzAdBgNVHQ4EFgQU/KgHUtnvKf6YQzwVXHRet39z4K8w
// SIG // HwYDVR0jBBgwFoAU1WM6XIoxkPNDe3xGG8UzaFqFbVUw
// SIG // VgYDVR0fBE8wTTBLoEmgR4ZFaHR0cDovL2NybC5taWNy
// SIG // b3NvZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvTWljVGlt
// SIG // U3RhUENBXzIwMTAtMDctMDEuY3JsMFoGCCsGAQUFBwEB
// SIG // BE4wTDBKBggrBgEFBQcwAoY+aHR0cDovL3d3dy5taWNy
// SIG // b3NvZnQuY29tL3BraS9jZXJ0cy9NaWNUaW1TdGFQQ0Ff
// SIG // MjAxMC0wNy0wMS5jcnQwDAYDVR0TAQH/BAIwADATBgNV
// SIG // HSUEDDAKBggrBgEFBQcDCDANBgkqhkiG9w0BAQsFAAOC
// SIG // AQEAkv2A93W9ZZA+F83VFYPFjgKRO6xOfWDvjzkGk5Dj
// SIG // D6pFPYk/Av3sb7hQkAlshNI3IZmxwYZ2HeQNxo7/GOCi
// SIG // +ka1hXd0bk4MREXQvNK2BH5wSw/WqwdpVkp2ZOj5qkej
// SIG // o4bc9M9EuEkQW2eP0dp5rjrdh1MG6I9q/H/X5KOGRRUN
// SIG // kWIiOpBK49hoAUnJLQ5reGwRAvSPTRFgc6gDIQ2X4w9y
// SIG // dbv96A646/wgQZ2Ok/3FM3M+OXq9ajQeOUdiEbUc71f0
// SIG // c4Nxn6gUZb7kA45NbcQBMxt+V+yh8xyXqTin9Kg6OfmJ
// SIG // NfxdoyKuCr2NDKsxEm7pvWEW7PQZOiSFYl+psqGCA3Yw
// SIG // ggJeAgEBMIHjoYG5pIG2MIGzMQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMQ0wCwYDVQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lw
// SIG // aGVyIERTRSBFU046RjUyOC0zNzc3LThBNzYxJTAjBgNV
// SIG // BAMTHE1pY3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZpY2Wi
// SIG // JQoBATAJBgUrDgMCGgUAAxUAvIT7nVsS2sc2hTuIZp6j
// SIG // FhjVzByggcIwgb+kgbwwgbkxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxJzAlBgNVBAsTHm5DaXBo
// SIG // ZXIgTlRTIEVTTjo1N0Y2LUMxRTAtNTU0QzErMCkGA1UE
// SIG // AxMiTWljcm9zb2Z0IFRpbWUgU291cmNlIE1hc3RlciBD
// SIG // bG9jazANBgkqhkiG9w0BAQUFAAIFANwNhAgwIhgPMjAx
// SIG // NjEyMjgwMDIxMjhaGA8yMDE2MTIyOTAwMjEyOFowdDA6
// SIG // BgorBgEEAYRZCgQBMSwwKjAKAgUA3A2ECAIBADAHAgEA
// SIG // AgIDvzAHAgEAAgIX6jAKAgUA3A7ViAIBADA2BgorBgEE
// SIG // AYRZCgQCMSgwJjAMBgorBgEEAYRZCgMBoAowCAIBAAID
// SIG // FuNgoQowCAIBAAIDB6EgMA0GCSqGSIb3DQEBBQUAA4IB
// SIG // AQAyuqUJMJCuOVNvCziwOxZ18Vganx0oNuZT5/aNMxCI
// SIG // dUQdYWGXRZ7gid4VNlI0kWVRHBg2R54eGMIzyDAu4Njh
// SIG // Ubd3YI9jS+eTLuzeSHN+exSNYIUG47WDFu2OZ1IvwVtw
// SIG // nV012Tn12dYeuq+fZEsJ4wZai/QcGHhVSgziwl2OOPu+
// SIG // eLrTCvy8km2fNRWATfAkpMh5RKhWPgRzX6VL36qn8vg7
// SIG // qibzzOPj6vmjG9g6R8HjniSg+Is256ScHxHsZENa4dbn
// SIG // 6kD/WVGURxTABfUEYGTY9hBEIfNjOqy+dB+G4R8k8ApD
// SIG // MSqT4J/MCOoi2dXO1EJsIs6whnhlodJS3BITMYIC9TCC
// SIG // AvECAQEwgZMwfDELMAkGA1UEBhMCVVMxEzARBgNVBAgT
// SIG // Cldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAc
// SIG // BgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEmMCQG
// SIG // A1UEAxMdTWljcm9zb2Z0IFRpbWUtU3RhbXAgUENBIDIw
// SIG // MTACEzMAAACwhumSIApd6vgAAAAAALAwDQYJYIZIAWUD
// SIG // BAIBBQCgggEyMBoGCSqGSIb3DQEJAzENBgsqhkiG9w0B
// SIG // CRABBDAvBgkqhkiG9w0BCQQxIgQgUIRh0ENVDMKRr65i
// SIG // B7LL+vRktjh4rS6DgCNl1Gz+PNEwgeIGCyqGSIb3DQEJ
// SIG // EAIMMYHSMIHPMIHMMIGxBBS8hPudWxLaxzaFO4hmnqMW
// SIG // GNXMHDCBmDCBgKR+MHwxCzAJBgNVBAYTAlVTMRMwEQYD
// SIG // VQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25k
// SIG // MR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24x
// SIG // JjAkBgNVBAMTHU1pY3Jvc29mdCBUaW1lLVN0YW1wIFBD
// SIG // QSAyMDEwAhMzAAAAsIbpkiAKXer4AAAAAACwMBYEFIrs
// SIG // USfNp+vcbANMs4cNSbj79izoMA0GCSqGSIb3DQEBCwUA
// SIG // BIIBAJMGZBr98b2A4xLSZXU8yDy2qZl9XAdSX0NRNpFU
// SIG // 3eOU5MxKENKSO0eNHn/Zoz5DOAjXuRBnlypstaA9uDqT
// SIG // cYZj6aNBrvgY9P1w1XQ6AYCfl1dYlgWO5EhjLPFCd0NB
// SIG // t4q46Kr2M0fIKxzmgLPDta86oI4442p5Sma5dO8mo7//
// SIG // ByKeM9U7PTckeAmvNaNfTXC6pyX4LcV1mJ0cA2dLJH9O
// SIG // e66BV+Y0u066NhKHwRtgrOUDG7cSEnO1VRV7FSmBtHoA
// SIG // lOVZyjes0vsgLiX7Zn6S34JNQLl3ADN+W6tic/xsKOEQ
// SIG // 3SYr5Ukadmhs+A0g5SS7OJFuIxw9LTUPmq76264=
// SIG // End signature block
